/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.AbstractAuimlTag;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.TagUtils;
import java.beans.Introspector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StringTag
extends AbstractAuimlTag {
    String name;
    String type = this.getAttribute("CONTROL-TYPE");
    String enabled;
    String shown;
    String selected;
    String notifyComplete;
    String readOnly;
    String optimumLength;
    String optimumSize;
    String obscured;
    String anchor;
    String tabOrder;
    String fill;
    String bindingProperty;
    String fixedFont;
    String enumeration;
    String maxLength;
    String wrap;

    public StringTag(Element auimlElement, Document hmcmlDocument, String resource, String[] resources) {
        super(auimlElement, hmcmlDocument, resource, resources);
        if (this.type == null) {
            this.type = "";
        }
        this.name = this.getAttribute("NAME");
        this.enabled = this.getAttribute("ENABLED");
        if (this.enabled == null || this.enabled.equals("")) {
            this.enabled = "TRUE";
        }
        this.shown = this.getAttribute("SHOWN");
        if (this.shown == null || this.shown.equals("")) {
            this.shown = "TRUE";
        }
        this.selected = this.getAttribute("SELECTED");
        if (this.selected == null || this.selected.equals("")) {
            this.selected = "FALSE";
        }
        this.notifyComplete = this.getAttribute("NOTIFY-COMPLETE");
        if (this.notifyComplete == null || this.notifyComplete.equals("")) {
            this.notifyComplete = "FALSE";
        }
        if (this.getElement().getElementsByTagName("WHEN-SELECTED").getLength() > 0) {
            this.notifyComplete = "TRUE";
        }
        this.enabled = this.getAttribute("ENABLED");
        if (this.enabled == null || this.enabled.equals("")) {
            this.enabled = "TRUE";
        }
        this.shown = this.getAttribute("SHOWN");
        if (this.shown == null || this.shown.equals("")) {
            this.shown = "TRUE";
        }
        this.readOnly = this.getAttribute("READ-ONLY");
        if (this.readOnly == null || this.readOnly.equals("")) {
            this.readOnly = "FALSE";
        }
        this.optimumLength = this.getAttribute("OPTIMUM-LENGTH");
        if (this.optimumLength == null || this.optimumLength.equals("")) {
            this.optimumLength = "";
        }
        this.maxLength = this.getAttribute("MAX-LENGTH");
        if (this.maxLength == null) {
            this.maxLength = "";
        }
        this.wrap = this.getAttribute("LINE-WRAP");
        if (this.wrap == null) {
            this.wrap = "";
        }
        this.optimumSize = this.getAttribute("OPTIMUM-SIZE");
        if (this.optimumSize == null) {
            this.optimumSize = "";
        }
        this.obscured = this.getAttribute("OBSCURED");
        if (this.obscured == null || this.obscured.equals("")) {
            this.obscured = "FALSE";
        }
        this.tabOrder = this.getAttribute("TABORDER");
        if (this.tabOrder == null) {
            this.tabOrder = "";
        }
        this.anchor = this.getAttribute("ANCHOR");
        if (this.anchor == null || this.anchor.equals("")) {
            this.anchor = "DEFAULT";
        }
        this.fill = this.getAttribute("FILL");
        if (this.fill == null) {
            this.fill = "";
        }
        this.fixedFont = this.getAttribute("FIXED-FONT");
        if (this.fixedFont == null) {
            this.fixedFont = "";
        }
        this.enumeration = this.getAttribute("ENUMERATION");
        if (this.enumeration == null) {
            this.enumeration = "NONE";
        }
        this.bindingProperty = this.getBindingProperty();
        if (this.bindingProperty == null) {
            this.bindingProperty = "";
        }
    }

    public void startHMCMLTag() {
        if (this.isTableElement()) {
            this.addTableColumn();
        } else if (this.isChoiceElement()) {
            this.addChoiceTag();
        } else if (this.type.equals("LABEL")) {
            this.addLabelTag();
        } else if (this.type.equals("COMBOBOX")) {
            this.addComboBoxTag();
        } else if (this.type.equals("LIST")) {
            this.addListTag();
        } else if (this.type.equals("TEXTAREA")) {
            this.addTextAreaTag();
        } else if (this.type.equals("SPINNER")) {
            this.addSpinnerTag();
        } else if (this.type.equals("TEXTFIELD")) {
            if (this.bindingProperty.equals("")) {
                this.addLabelTag();
            } else {
                this.addTextEntryTag();
            }
        } else if (this.bindingProperty.equals("")) {
            this.addLabelTag();
        } else {
            this.addTextEntryTag();
        }
        if (!this.isTableElement()) {
            this.checkStateChange();
            this.addValidator();
        }
    }

    void addTableColumn() {
        Element column;
        Element auimlTable = (Element)this.getElement().getParentNode().getParentNode();
        String binding = auimlTable.getAttribute("BINDING");
        if (binding != null && !binding.equals("")) {
            column = this.hmcmlDocument.createElementNS("acvt", "Row");
        } else {
            column = this.hmcmlDocument.createElementNS("acvt", "Column");
            String colBinding = this.getAttribute("BINDING");
            try {
                colBinding = colBinding.substring(colBinding.indexOf("#") + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            column.setAttribute("binding_id", colBinding);
        }
        this.addHmcId(column, this.name);
        column.setAttribute("type", this.getElement().getTagName());
        column.setAttribute("fixedFont", this.fixedFont);
        column.setAttribute("read-only", this.readOnly);
        column.setAttribute("optimumLength", this.optimumLength);
        column.setAttribute("maxLength", this.maxLength);
        NodeList nl = this.getElement().getElementsByTagName("VALID-VALUE");
        if (nl.getLength() > 0 && !this.enumeration.equals("NONE")) {
            column.setAttribute("style", "combobox");
        }
        this.getHmcmlMountPoint().appendChild(column);
        this.setHmcmlElement(column);
    }

    void addLabelTag() {
        String keyExtension = ".VALUE";
        Element cell = this.findPosition();
        Element flowableTable = this.hmcmlDocument.createElement("table");
        flowableTable.setAttribute("cellspacing", "0");
        flowableTable.setAttribute("cellpadding", "0");
        Element flowableTr = this.hmcmlDocument.createElement("tr");
        Element flowableTd = this.hmcmlDocument.createElement("td");
        flowableTr.appendChild(flowableTd);
        flowableTable.appendChild(flowableTr);
        if (this.getAttribute("BINDING") == null || this.getAttribute("BINDING").equals("")) {
            Text text;
            String txt = this.getAttribute("PANEL-NAME") + "." + this.name + keyExtension;
            if (useELExpressions) {
                text = this.hmcmlDocument.createTextNode("${" + txt.replace('.', '_') + "}");
                Element fmtMessage = this.hmcmlDocument.createElementNS("fmt", "message");
                fmtMessage.setAttribute("key", txt);
                fmtMessage.setAttribute("var", txt.replace('.', '_'));
                cell.appendChild(fmtMessage);
            } else {
                String resourceText = this.fetchResourceValue(txt, false, true, true, true);
                if (resourceText == null || resourceText.trim().equals("")) {
                    resourceText = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                }
                text = this.hmcmlDocument.createTextNode(resourceText);
            }
            Element label = this.hmcmlDocument.createElement("label");
            this.addHmcId(label, this.name);
            label.appendChild(text);
            flowableTd.appendChild(label);
            cell.appendChild(flowableTable);
            this.setHmcmlElement(label);
        } else {
            Element label = this.hmcmlDocument.createElement("label");
            this.addHmcId(label, this.name);
            String binding = this.getAttribute("BINDING");
            try {
                binding = binding.substring(binding.indexOf("#") + 1);
            }
            catch (Exception e) {
                binding = this.name;
            }
            label.appendChild(this.hmcmlDocument.createTextNode("${databean." + Introspector.decapitalize(binding) + "}"));
            flowableTd.appendChild(label);
            cell.appendChild(flowableTable);
            this.setHmcmlElement(label);
        }
    }

    void addChoiceTag() {
        String notifySelect;
        String captionAnchor;
        Element cell;
        String keyExtension = ".TEXT";
        NodeList nl = this.getElement().getChildNodes();
        int nlLength = nl.getLength();
        for (int i = 0; i < nlLength; ++i) {
            if (!(nl.item(i) instanceof Element) || !((Element)nl.item(i)).getTagName().equals("VALUE")) continue;
            keyExtension = ".VALUE";
        }
        Element containingTable = null;
        if (this.getHmcmlMountPoint() != null && this.getHmcmlMountPoint().getTagName().equals("table") && this.getHmcmlMountPoint().getAttribute("name").equals(this.getContainingElementName())) {
            containingTable = this.getHmcmlMountPoint();
        }
        if (containingTable == null) {
            containingTable = TagUtils.findTable(this.getContainingElementName(), this.hmcmlDocument);
        }
        if ((cell = TagUtils.findCell(this.getRelatedAttribute("CELL"), containingTable)) == null) {
            cell = this.findPosition();
        }
        if ((captionAnchor = this.getRelatedAttribute("ANCHOR")) == null || captionAnchor.equals("")) {
            captionAnchor = "WEST";
        }
        this.getElement().setAttribute("ANCHOR", captionAnchor);
        Element auimlChoice = (Element)this.getElement().getParentNode();
        Element hmcmlcvt = auimlChoice.getAttribute("SELECTION-POLICY") != null && auimlChoice.getAttribute("SELECTION-POLICY").equals("MULTIPLE") ? this.hmcmlDocument.createElementNS("acvt", "CheckBox") : this.hmcmlDocument.createElementNS("acvt", "RadioButton");
        this.addHmcId(hmcmlcvt, this.name);
        hmcmlcvt.setAttribute("choiceName", this.name);
        String choiceBinding = auimlChoice.getAttribute("BINDING");
        if (choiceBinding != null) {
            choiceBinding = choiceBinding.substring(choiceBinding.indexOf("#") + 1);
            Introspector.decapitalize(choiceBinding);
            hmcmlcvt.setAttribute("group", choiceBinding);
        }
        hmcmlcvt.setAttribute("isEnabled", this.enabled.equals("TRUE") ? "true" : "false");
        hmcmlcvt.setAttribute("isVisible", this.shown.equals("TRUE") ? "true" : "false");
        if (this.selected.equals("TRUE")) {
            hmcmlcvt.setAttribute("isChecked", "true");
        }
        if ((notifySelect = auimlChoice.getAttribute("NOTIFY-SELECTION")) == null || notifySelect.equals("")) {
            notifySelect = "FALSE";
        }
        if (auimlChoice.getElementsByTagName("WHEN-SELECTED").getLength() > 0) {
            notifySelect = "TRUE";
        }
        hmcmlcvt.setAttribute("notifySelect", notifySelect.equals("TRUE") ? "immediate" : "delayed");
        if (!this.tabOrder.equals("")) {
            hmcmlcvt.setAttribute("tabIndex", this.tabOrder);
        }
        cell.appendChild(hmcmlcvt);
        this.setHmcmlElement(hmcmlcvt);
        this.addHelpToHmcmlElement();
        if (!this.bindingProperty.equals("")) {
            String binding = this.getAttribute("BINDING");
            try {
                binding = binding.substring(binding.indexOf("#") + 1);
            }
            catch (Exception e) {
                binding = this.name;
            }
            hmcmlcvt.setAttribute("text", "${databean." + Introspector.decapitalize(binding) + "}");
        } else if (this.getElement().getElementsByTagName("VALUE").getLength() > 0) {
            Element valueElement = (Element)this.getElement().getElementsByTagName("VALUE").item(0);
            String value = valueElement.getAttribute("NL:SRC");
            if (value == null || value.equals("")) {
                value = valueElement.getAttributeNS("NL", "SRC");
            }
            if (value != null && !value.equals("")) {
                value = value.substring("resource://".length());
                if (useELExpressions) {
                    hmcmlcvt.setAttribute("text", "${" + value.replace('.', '_') + "}");
                    Element fmtMessage = this.hmcmlDocument.createElementNS("fmt", "message");
                    fmtMessage.setAttribute("key", value);
                    fmtMessage.setAttribute("var", value.replace('.', '_'));
                    cell.insertBefore(fmtMessage, hmcmlcvt);
                } else {
                    hmcmlcvt.setAttribute("text", this.fetchResourceValue(value));
                }
            }
        }
    }

    void addComboBoxTag() {
        String maxLength;
        Element cell = this.findPosition();
        Element wComboBox = this.hmcmlDocument.createElementNS("wcl", "WComboBox");
        wComboBox.setAttribute("isEnabled", this.enabled.equals("TRUE") ? "true" : "false");
        if (this.enumeration.equals("CLOSED")) {
            wComboBox.setAttribute("isEditable", "false");
        } else {
            wComboBox.setAttribute("isEditable", this.readOnly.equals("FALSE") ? "true" : "false");
        }
        wComboBox.setAttribute("isVisible", this.shown.equals("TRUE") ? "true" : "false");
        if (!this.tabOrder.equals("")) {
            wComboBox.setAttribute("tabIndex", this.tabOrder);
        }
        if (!this.optimumLength.equals("")) {
            wComboBox.setAttribute("textEntrySize", this.optimumLength);
        }
        if ((maxLength = this.getAttribute("MAX-LENGTH")) == null) {
            maxLength = "";
        }
        if (!maxLength.equals("")) {
            wComboBox.setAttribute("textEntryMaxLength", maxLength);
        }
        if (this.readOnly.equals("FALSE")) {
            String bundle = "com.ibm.hwmca.fw.res.common";
            Element fmtSetBundle = this.hmcmlDocument.createElementNS("fmt", "setBundle");
            fmtSetBundle.setAttribute("var", "commonbundle");
            fmtSetBundle.setAttribute("basename", bundle);
            Element fmtMessage1 = this.hmcmlDocument.createElementNS("fmt", "message");
            Element fmtMessage2 = this.hmcmlDocument.createElementNS("fmt", "message");
            String htmleditablecomboboxentry = "html.editablecombobox.entry";
            String htmleditablecomboboxtext = "html.editablecombobox.text";
            fmtMessage1.setAttribute("key", htmleditablecomboboxentry);
            fmtMessage1.setAttribute("var", htmleditablecomboboxentry.replace('.', '_'));
            fmtMessage1.setAttribute("bundle", "${commonbundle}");
            fmtMessage2.setAttribute("key", htmleditablecomboboxtext);
            fmtMessage2.setAttribute("var", htmleditablecomboboxtext.replace('.', '_'));
            fmtMessage2.setAttribute("bundle", "${commonbundle}");
            cell.appendChild(fmtSetBundle);
            cell.appendChild(fmtMessage1);
            cell.appendChild(fmtMessage2);
            wComboBox.setAttribute("addOptionText", "${" + htmleditablecomboboxentry.replace('.', '_') + "}");
            wComboBox.setAttribute("initialEntryFieldText", "${" + htmleditablecomboboxtext.replace('.', '_') + "}");
        }
        this.addHmcId(wComboBox, this.name);
        wComboBox.setAttributeNS("hmc", "model", this.name);
        wComboBox.setAttributeNS("hmc", "notifySelect", this.notifyComplete.equals("TRUE") ? "immediate" : "delayed");
        Element dataModel = this.hmcmlDocument.createElementNS("hmc", "DataModel");
        this.addHmcId(dataModel, this.name + "_model");
        dataModel.setAttribute("binding_id", this.getBindingProperty());
        wComboBox.appendChild(dataModel);
        cell.appendChild(wComboBox);
        this.setHmcmlElement(wComboBox);
        this.addHelpToHmcmlElement();
    }

    void addListTag() {
        Element cell = this.findPosition();
        Element wSelectionBox = this.hmcmlDocument.createElementNS("wcl", "WSelectionBox");
        wSelectionBox.setAttribute("isEnabled", this.enabled.equals("TRUE") ? "true" : "false");
        wSelectionBox.setAttribute("isVisible", this.shown.equals("TRUE") ? "true" : "false");
        if (!this.tabOrder.equals("")) {
            wSelectionBox.setAttribute("tabIndex", this.tabOrder);
        }
        wSelectionBox.setAttributeNS("hmc", "model", this.name);
        this.addHmcId(wSelectionBox, this.name);
        wSelectionBox.setAttributeNS("hmc", "notifySelect", this.notifyComplete.equals("TRUE") ? "immediate" : "delayed");
        Element dataModel = this.hmcmlDocument.createElementNS("hmc", "DataModel");
        this.addHmcId(dataModel, this.name + "_model");
        dataModel.setAttribute("binding_id", this.getBindingProperty());
        wSelectionBox.appendChild(dataModel);
        if (this.enumeration.equals("CLOSEDMULTISELECT")) {
            wSelectionBox.setAttribute("isMultiple", "true");
            dataModel.setAttributeNS("acvt", "isMultiple", "true");
        } else {
            wSelectionBox.setAttribute("isMultiple", "false");
            dataModel.setAttributeNS("acvt", "isMultiple", "false");
        }
        if (!this.optimumSize.equals("")) {
            wSelectionBox.setAttribute("size", this.optimumSize);
        }
        cell.appendChild(wSelectionBox);
        this.setHmcmlElement(wSelectionBox);
        this.addHelpToHmcmlElement();
    }

    void addTextAreaTag() {
        Element cell = this.findPosition();
        Element wTextArea = this.hmcmlDocument.createElementNS("wcl", "WTextArea");
        wTextArea.setAttribute("isEnabled", this.enabled.equals("TRUE") ? "true" : "false");
        wTextArea.setAttribute("isReadOnly", this.readOnly.equals("TRUE") ? "true" : "false");
        wTextArea.setAttribute("isVisible", this.shown.equals("TRUE") ? "true" : "false");
        wTextArea.setAttribute("wrap", this.wrap.equals("FALSE") ? "off" : "soft");
        if (!this.tabOrder.equals("")) {
            wTextArea.setAttribute("tabIndex", this.tabOrder);
        }
        if (!this.optimumSize.equals("")) {
            wTextArea.setAttribute("rows", this.optimumSize);
        }
        if (!this.optimumLength.equals("")) {
            wTextArea.setAttribute("columns", this.optimumLength);
        }
        wTextArea.setAttributeNS("hmc", "property", this.getBindingProperty());
        this.addHmcId(wTextArea, this.name);
        cell.appendChild(wTextArea);
        if (this.fixedFont.equals("TRUE")) {
            Element attrElement = null;
            attrElement = this.hmcmlDocument.createElementNS("wcl", "Attribute");
            attrElement.setAttribute("name", "style");
            attrElement.setAttribute("value", "font-family:monospace;");
            wTextArea.appendChild(attrElement);
        }
        this.setHmcmlElement(wTextArea);
        this.addHelpToHmcmlElement();
    }

    void addTextEntryTag() {
        String maxLength;
        Element cell = this.findPosition();
        Element wTextEntry = this.hmcmlDocument.createElementNS("wcl", "WTextEntry");
        wTextEntry.setAttribute("isEnabled", this.enabled.equals("TRUE") ? "true" : "false");
        wTextEntry.setAttribute("isPassword", this.obscured.equals("TRUE") ? "true" : "false");
        wTextEntry.setAttribute("isReadOnly", this.readOnly.equals("TRUE") ? "true" : "false");
        wTextEntry.setAttribute("isVisible", this.shown.equals("TRUE") ? "true" : "false");
        if (!this.tabOrder.equals("")) {
            wTextEntry.setAttribute("tabIndex", this.tabOrder);
        }
        if (!this.optimumLength.equals("")) {
            wTextEntry.setAttribute("size", this.optimumLength);
        } else {
            try {
                String size = this.getAttribute("SIZE");
                if (size == null) {
                    size = "";
                }
                if (!size.equals("") && !size.startsWith("-1")) {
                    if (size.indexOf(",") > 0) {
                        size = size.substring(0, size.indexOf(","));
                        int cvtSize = Integer.parseInt(size) / 11;
                        wTextEntry.setAttribute("size", new Integer(cvtSize).toString());
                    } else {
                        wTextEntry.setAttribute("size", size);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.fixedFont.equals("TRUE")) {
            Element attrElement = this.hmcmlDocument.createElementNS("wcl", "Attribute");
            attrElement.setAttribute("name", "style");
            attrElement.setAttribute("value", "font-family:monospace;");
            wTextEntry.appendChild(attrElement);
        }
        if ((maxLength = this.getAttribute("MAX-LENGTH")) == null) {
            maxLength = "";
        }
        if (!maxLength.equals("")) {
            wTextEntry.setAttribute("maxLength", maxLength);
        }
        wTextEntry.setAttributeNS("hmc", "property", this.getBindingProperty());
        this.addHmcId(wTextEntry, this.name);
        cell.appendChild(wTextEntry);
        this.setHmcmlElement(wTextEntry);
        this.addHelpToHmcmlElement();
    }

    void addSpinnerTag() {
        this.readOnly = "FALSE";
        this.addTextEntryTag();
    }

    void addUnknownTag() {
        Element cell = this.findPosition();
        Element label = this.hmcmlDocument.createElement("label");
        this.addHmcId(label, this.name);
        cell.appendChild(label);
        this.setHmcmlElement(label);
    }

    void adjustFill() {
        if (this.type.equals("TEXTAREA") || this.type.equals("LABEL") || this.type.equals("TEXTFIELD") || this.type.equals("COMBOBOX") || this.type.equals("LIST") || this.type.equals("")) {
            String fill = this.getAttribute("FILL");
            if (fill == null) {
                fill = "";
            }
            Element attrElement = null;
            if (this.getHmcmlElement() != null && this.getHmcmlElement().getParentNode() != null && this.getHmcmlElement().getParentNode() instanceof Element && ((Element)this.getHmcmlElement().getParentNode()).getTagName().equals("td")) {
                Element cell = (Element)this.getHmcmlElement().getParentNode();
                if (fill.equals("BOTH")) {
                    attrElement = this.hmcmlDocument.createElementNS("wcl", "Attribute");
                    attrElement.setAttribute("name", "style");
                    attrElement.setAttribute("value", "width:100%;height:100%;");
                    this.hmcmlElement.appendChild(attrElement);
                } else if (fill.equals("HORIZONTAL")) {
                    attrElement = this.hmcmlDocument.createElementNS("wcl", "Attribute");
                    attrElement.setAttribute("name", "style");
                    attrElement.setAttribute("value", "width:100%;");
                    this.hmcmlElement.appendChild(attrElement);
                } else if (fill.equals("VERTICAL")) {
                    attrElement = this.hmcmlDocument.createElementNS("wcl", "Attribute");
                    attrElement.setAttribute("name", "style");
                    attrElement.setAttribute("value", "height:100%;");
                    this.hmcmlElement.appendChild(attrElement);
                }
            }
        }
    }

    public void addValidator() {
        if (!(this.type.equals("LABEL") || this.isChoiceElement() || this.type.equals("LIST"))) {
            String formatBinding;
            String mandatory;
            String maxLength;
            String minLength = this.getAttribute("MIN-LENGTH");
            if (minLength == null) {
                minLength = "";
            }
            if ((maxLength = this.getAttribute("MAX-LENGTH")) == null) {
                maxLength = "";
            }
            if ((mandatory = this.getAttribute("MANDATORY")) == null || mandatory.equals("")) {
                mandatory = "FALSE";
            }
            if ((formatBinding = this.getAttribute("FORMAT-BINDING")) == null) {
                formatBinding = "";
            }
            if (!(minLength.equals("") && maxLength.equals("") && mandatory.equals("FALSE") && formatBinding.equals(""))) {
                Element auimlFormatter = this.hmcmlDocument.createElementNS("hmc", "Format");
                auimlFormatter.setAttribute("class", "com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters.AuimlDefaultFormatter");
                auimlFormatter.setAttribute("maxLength", maxLength);
                auimlFormatter.setAttribute("minLength", minLength);
                auimlFormatter.setAttribute("required", mandatory);
                auimlFormatter.setAttribute("type", "STRING");
                auimlFormatter.setAttribute("FORMAT-BINDING", formatBinding);
                this.getHmcmlElement().appendChild(auimlFormatter);
            }
        }
    }

    public void checkStateChange() {
        if (this.getElement().getElementsByTagName("WHEN-SELECTED").getLength() > 0) {
            Element hmc = this.getHmcmlElement();
            if (hmc.getNamespaceURI() != null && hmc.getNamespaceURI().equals("hmc")) {
                hmc.setAttribute("notifySelect", "immediate");
            } else {
                hmc.setAttributeNS("hmc", "notifySelect", "immediate");
            }
        }
    }

    public void adjustColspan() {
        if (!this.isChoiceElement() && !this.isTableElement() && this.type.equals("LABEL")) {
            if (this.getHmcmlElement() != null) {
                Element firstTd = TagUtils.findParentWithTagName(this.getHmcmlElement(), "td");
                if (firstTd.getParentNode() != null && firstTd.getParentNode() instanceof Element) {
                    Element secondTd = TagUtils.findParentWithTagName((Element)firstTd.getParentNode(), "td");
                    TagUtils.adjustColspan(this.getAttribute("COLSPAN"), secondTd);
                } else {
                    TagUtils.adjustColspan(this.getAttribute("COLSPAN"), firstTd);
                }
            }
        } else {
            super.adjustColspan();
        }
    }
}

